IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE
								TABLE_NAME ='PG_DEB_PAGFOR_OCORR' AND COLUMN_NAME ='CD_BC')
BEGIN
	ALTER TABLE [PG_DEB_PAGFOR_OCORR] ADD CD_BC INT DEFAULT 0 NOT NULL;
END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE='FOREIGN KEY' AND CONSTRAINT_NAME = 'FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_OCORR')
	ALTER TABLE [DBO].[PG_DEB_PAGFOR_RETORNO] DROP CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_OCORR];
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE='PRIMARY KEY' AND CONSTRAINT_NAME = 'PK_PG_DEB_PAGFOR_OCORR')
	ALTER TABLE [DBO].[PG_DEB_PAGFOR_OCORR] DROP CONSTRAINT [PK_PG_DEB_PAGFOR_OCORR];
GO

ALTER TABLE [DBO].[PG_DEB_PAGFOR_OCORR] ADD  CONSTRAINT [PK_PG_DEB_PAGFOR_OCORR] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_OCORR] ASC,
	[CD_BC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

ALTER TABLE [DBO].[PG_DEB_PAGFOR_RETORNO]  WITH NOCHECK ADD  CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_OCORR] FOREIGN KEY([CD_EMP], [CD_OCORR], [CD_BC])
REFERENCES [DBO].[PG_DEB_PAGFOR_OCORR] ([CD_EMP], [CD_OCORR], [CD_BC])
ON UPDATE CASCADE
GO

ALTER TABLE [DBO].[PG_DEB_PAGFOR_RETORNO] CHECK CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_OCORR]
GO
